include("../src/SI.jl")
using PlotlyJS

n = 30
m = 1000
x = linspace(-1.0, 1.0, m)
w = 

K = zeros(n, m)
for i = 1:n
    K[i,:] = cos.(i * acos.(x));
end
    
(Q, R, p) = qr(K, Val{true})
nP = SI.cut_spectrum_l2(abs.(diag(R)), 1e-10, bypasssort=true)

X = x[p[1:nP]]

(nP, trash, x_cheb, trash) = SI.getChebyshevNodes(nP, -1.0, 1.0)

lyt = PlotlyJS.Layout(title="Xhat", xaxis_title="x")
plt1 = PlotlyJS.scatter(x=X[:],y=ones(size(X[:])),name="X selected by RRQR",mode="markers",marker_size="10")
plt2 = PlotlyJS.scatter(x=x_cheb[:],y=2.*ones(size(x_cheb[:])),name="Usual cheb nodes",mode="markers",marker_size="10")
plt3 = PlotlyJS.scatter(x=x,y=3.*ones(size(x[:])),name="Uniform grid",mode="markers",marker_size="2")
plt = PlotlyJS.plot([plt1, plt2, plt3], lyt)
