include("../src/SI.jl")
include("../benchmarks/geometries.jl")
using PyPlot
PyPlot.close("all")
kernel = (x,y) -> 1./SI.distance_2(x,y)
coefs = [-0.75 -0.5 -0.25 0 0.25 0.5 0.75 1 1.25 1.5 1.75 2]

for i = 1:length(coefs)
    (X, Y, b1, b2) = getGeometry(10,30,coef=coefs[i])
    PyPlot.figure(i)
    SI.plotBoundingBox(b1, i)
    SI.plotBoundingBox(b2, i)
    tol = 1e-4
    (U, F, V, Xk, Yk, Ub, Fb, Vb, I1, I2, diags) = SI.meshKernelLowRankAdaptive(kernel, b1, b2, X, Y, tol, ruletype=SI.chebyshev, useSI=true, logLevel=SI.debug)
    PyPlot.plot(Xk[1,:],Xk[2,:],"*r")
    PyPlot.plot(Yk[1,:],Yk[2,:],"*b")
    savefig(string("squares", coefs[i], ".eps"))
end
