# Load and plot results
include("../src/SI.jl")
include("../benchmarks/geometries.jl")
# using PyPlot
using PlotlyJS
using Iterators
using JLD
PyPlot.close("all")
srand(0)

# Get date
# date_run = "2017-11-10T13.57.37.992"
date_run = "2017-11-10T13.46.09.439"
folder = "results-noplots/"

# geos = 1:9
kernels = 1:1
line_styles = ["-","--","-."]

# Load stuff
figid = 0
for i = 10:10

    geos = i:i # For partial runs
    geo = 1

    for ker = 1:1
        # Get file
        filename = string(folder, "/results-",date_run,"-geo",geos[geo],"-kernel",kernels[ker],".jld")
        @printf "Loading %s\n" filename
        data = load(filename)
        # Plot
        err = data["err"]
        ranks_uncomp = data["ranks_uncomp"]
        ranks_comp = data["ranks_comp"]
        ranks_opt = data["ranks_opt"]
        ranks_rrqr = data["ranks_rrqr"]
        tols = data["tols"]
        kernels_name = data["kernel"]
        method_name = data["method"]
        geo_names = data["geo_names"]
        geos2 = data["geos"]
        sizes_comp = data["sizes_comp"]
        sizes_uncomp = data["sizes_uncomp"]
        coef = data["coef"]
        @assert geos2 == geos
        @assert length(kernels) == length(kernels_name)

        (trash1, trash2, b1, b2) = getGeometry(geos[geo], 10, coef=coef)

        # Geometry (plot or not)
        if false
            # Plot geometry
            PyPlot.figure()
            X = data["X"]
            Y = data["Y"]
            @printf "%d x %d points\n" size(X)[2] size(Y)[2]
            if size(X)[1] == 3
                PyPlot.plot3D(X[1,:],X[2,:],X[3,:],"or",markersize=2.5)
                PyPlot.plot3D(Y[1,:],Y[2,:],Y[3,:],"ob",markersize=2.5)
            else
                PyPlot.plot(X[1,:],X[2,:],"or",markersize=2.5)
                PyPlot.plot(Y[1,:],Y[2,:],"ob",markersize=2.5)
            end
            if geos[geo] <= 6 || geos[geo] >= 10
                SI.plotBoundingBox(b1)
                SI.plotBoundingBox(b2)
            end
            # Plot nodes
            PyPlot.figure()
            X = data["Xhat"][1,5]
            Y = data["Yhat"][1,5]
            if size(X)[1] == 3
                PyPlot.plot3D(X[1,:],X[2,:],X[3,:],"*r",markersize=2.5)
                PyPlot.plot3D(Y[1,:],Y[2,:],Y[3,:],"*b",markersize=2.5)
            else
                PyPlot.plot(X[1,:],X[2,:],"*r",markersize=2.5)
                PyPlot.plot(Y[1,:],Y[2,:],"*b",markersize=2.5)
            end
            if geos[geo] <= 6 || geos[geo] >= 10
                SI.plotBoundingBox(b1)
                SI.plotBoundingBox(b2)
            end
            PyPlot.title(geo_names[geos[geo]])
        end

        if true
            # Rank
            traces = Array{GenericTrace,1}(0)
            for m = 1:length(method_name)
                push!(traces,PlotlyJS.scatter(x=tols, y=ranks_uncomp[m,:], name="r0"))
            end
            for m = 1:length(method_name)
                push!(traces,PlotlyJS.scatter(x=tols, y=ranks_comp[m,:], name="r1"))
            end
            push!(traces,PlotlyJS.scatter(x=tols, y=ranks_rrqr, name="RRQR rank"))
            push!(traces,PlotlyJS.scatter(x=tols, y=ranks_opt, name="SVD rank"))
            lyt = PlotlyJS.Layout(xaxis_type="log", xaxis_exponentformat="e", title=string(geo_names[geos[geo]], " - ", kernels_name[ker]), xaxis_title="Relative Frobenius-norm error", yaxis_title="Rank", width=600, height=300, showgrid=true, font_size=15, legend_x=0.9, legend_y=0.9)
            plt = PlotlyJS.plot(traces, lyt)
            PlotlyJS.display(plt)
            PlotlyJS.savefig(plt, string("results-noplots/geo", geos[geo], "-kernel", ker, "-rank", ".eps"))

            traces = Array{GenericTrace,1}(0)
            for m = 1:length(method_name)
                push!(traces,PlotlyJS.scatter(x=tols, y=err[m,:], name="Error"))
            end
            push!(traces,PlotlyJS.scatter(x=tols, y=tols, name="Tol"))
            lyt = PlotlyJS.Layout(xaxis_type="log", xaxis_exponentformat="e", yaxis_type="log", yaxis_exponentformat="e", title=string(geo_names[geos[geo]], " - ", kernels_name[ker]), yaxis_title="Relative Frobenius-norm error", xaxis_title="Tols", width=400, height=400, showgrid=true, font_size=15)
            plt = PlotlyJS.plot(traces, lyt)
            PlotlyJS.display(plt)
            PlotlyJS.savefig(plt, string("results-noplots/geo", geos[geo], "-kernel", ker, "-error", ".eps"))
        end
       
    end
end


