include("../src/SI.jl")
include("../benchmarks/geometries.jl")

kernel = (x, y) -> log(SI.distance_2(x, y))
(X, Y, b1, b2) = getGeometry(10, 25)
tols = logspace(-1, -8, 8)
Atrue = SI.meshKernelFull(kernel, X, Y)
r_opts = SI.rank_eps_l2(Atrue, tols)
r_int  = zeros(Int64, length(tols))
r_comp = zeros(Int64, length(tols))

for (t, tol) in enumerate(tols) 
    (U, F, V, Xk, Yk, Uuc, Fuc, Vuc, I1, I2, diags) = SI.meshKernelLowRankAdaptive(kernel, b1, b2, X, Y, tol, ruletype=SI.chebyshev, useSI=false)
    r_int[t] = minimum(size(Fuc))
    r_comp[t] = minimum(size(F))
    # Error check
    e_int  = norm(Uuc*Fuc*Vuc' - Atrue)/norm(Atrue)
    e_comp = norm(U*F*V' - Atrue)/norm(Atrue)
    @printf "====> Errors : %e (int) -> %e (comp) vs %e (required)\n" e_int e_comp tol
end

using PyPlot
close("all")
figure(1)
semilogx(tols, r_int)
semilogx(tols, r_comp)
semilogx(tols, r_opts)
xlabel("Tol")
ylabel("Rank")
legend(("Interpolation", "SVD Recompression", "SVD Optimal"))
