# Load and plot results
include("../src/SI.jl")
#using PyPlot
using PlotlyJS
using Iterators
using JLD
PyPlot.close("all")

# filename = "results-perfs/2017-05-11/results-perfs-2017-05-11T10.00.34.599.jld"
# filename = "results-perfs/results-perfs-2017-10-04T10.42.59.763.jld"
# filename = "results-perfs/results-perfs-2017-10-04T10.50.11.505.jld"
# filename = "results-perfs/results-perfs-2017-10-04T10.54.47.048.jld"
# filename = "results-perfs/results-perfs-2017-10-04T10.59.27.748.jld"
# filename = "results-perfs/results-perfs-2017-10-04T11.11.26.973.jld" 
# filename = "results-perfs/results-perfs-2017-10-05T10.27.47.835.jld"
# filename = "results-perfs/results-perfs-2017-10-05T10.40.25.624.jld"
# filename = "results-perfs/results-perfs-2017-10-05T10.45.40.009.jld"
# filename = "results-perfs/results-perfs-2017-11-12T15.58.09.348.jld"
# filename = "results-perfs/results-perfs-2017-11-12T16.02.08.047.jld"
# filename = "results-perfs/results-perfs-2017-11-12T16.03.48.861.jld"
# filename = "results-perfs/results-perfs-2017-11-12T16.06.22.077.jld"
# filename = "results-perfs/results-perfs-2017-11-12T16.09.30.348.jld"
filename = "results-perfs/results-perfs-2017-11-12T16.46.13.281.jld"

@printf "Loading %s\n" filename
data = load(filename)
@printf "Loaded.\n"

t_Atrue = data["times_Atrue_s"] 
t_RRQR = data["times_RRQR_s"] 
t_LR = data["times_LR_s"]
t_Inv = data["times_Inverse_s"] 

tols = data["tols"]
coefs = data["coefs"]
ranks_LR = data["ranks_LR"]
errs_fro = data["errs_fro"]

nXnY = data["nXnY"]
    
colorNaive = "rgb(0,0,128)"
colorSI = "rgb(128,0,0)"

for c = 1:1#size(coefs, 1)
    t_At = t_Atrue[:,c,:]
    t_r = t_RRQR[:,end,c,:]
    t_l = t_LR[:,end,c,:]
    t_i = t_Inv[:,end,c,:]
    naive = median(t_At + t_r, 2)
    lr = median(t_l, 2)
    nXnYmini = nXnY[6:end]
        
    traces = Array{GenericTrace,1}(0)
    ids = (.!(isnan.(naive)))[:,1]
    ids2 = (.!(isnan.(lr)))[:,1]
    push!(traces, PlotlyJS.scatter(x=nXnY[ids], y=naive[ids], name="Naive algorithm", line_color=colorNaive))
    push!(traces, PlotlyJS.scatter(x=nXnY[ids2], y=lr[ids2], name="Chebyshev SI", line_color=colorSI))
    push!(traces, PlotlyJS.scatter(x=nXnYmini, y=nXnYmini.^2 / nXnYmini[1]^2 * naive[6], showlegend=false, line_color=colorNaive, mode="lines", line_dash="dot"))
    push!(traces, PlotlyJS.scatter(x=nXnY, y=nXnY.^2./1e6, name="n^2", line_color=colorNaive, mode="lines", line_dash="dash"))
    push!(traces, PlotlyJS.scatter(x=nXnY, y=nXnY   ./(4e5), name="n", line_color=colorSI, mode="lines", line_dash="dash"))
    lyt = PlotlyJS.Layout(xaxis_type="log", xaxis_exponentformat="e", yaxis_type="log", yaxis_exponentformat="e", title="Time as a function of n", yaxis_title="Time [s]", xaxis_title="n = |X| = |Y|", width=800, height=400, showgrid=true, font_size=15)
    plt = PlotlyJS.plot(traces, lyt)
    PlotlyJS.display(plt)
    PlotlyJS.savefig(plt, string("results-perfs/perf_n.eps"))

end

# for c = 1:size(coefs, 1)
#     for n = 1:size(nXnY, 1)
#         figure()
#         loglog(tols, tols)
#         loglog(tols, errs_fro[n,:,c], label="Frob Error")
#         xlabel("Tol")
#         ylabel("Err")
#         title(string("Error n ", nXnY[n], " c ", coefs[c]))
#     end
# end

t_l = t_LR[end,:,1,:]
t_i = t_Inv[end,:,1,:]
y1 = median(t_l, 2)[:]
y2 = 0.1 * log.(1./tols)
traces = Array{GenericTrace,1}(0)
push!(traces, PlotlyJS.scatter(x=tols, y=y1, name="Chebyshev SI", line_color=colorSI))
push!(traces, PlotlyJS.scatter(x=tols, y=y2, name="log(1/tol)", line_color=colorNaive))
lyt = PlotlyJS.Layout(xaxis_type="log", xaxis_exponentformat="e", yaxis_type="log", yaxis_exponentformat="e", title="Time as a function of the tolerance", yaxis_title="Time [s]", xaxis_title="Tolerance", width=400, height=400, showgrid=true, font_size=15, legend_x=0.7, legend_y=0.90)
plt = PlotlyJS.plot(traces, lyt)
PlotlyJS.display(plt)
PlotlyJS.savefig(plt, string("results-perfs/perf_tol.eps"))

t_l = t_LR[end,end,:,:]
t_i = t_Inv[end,end,:,:]
r_lr = ranks_LR[end,end,:,:]
x = mean(r_lr, 2)[:,1]
y = mean(t_l + t_i, 2)[:,1]
traces = Array{GenericTrace,1}(0)
push!(traces, PlotlyJS.scatter(x=x, y=y, line_color=colorSI))
lyt = PlotlyJS.Layout(title="Time as a function of the rank", yaxis_title="Time [s]", xaxis_title="Rank", width=400, height=400, showgrid=true, font_size=15)
plt = PlotlyJS.plot(traces, lyt)
PlotlyJS.display(plt)
PlotlyJS.savefig(plt, string("results-perfs/perf_rank.eps"))
