include("../src/SI.jl")
using PlotlyJS

# Geometry
# kernel = (x, y) -> 1./(1+25.*SI.distance_2(x,y).^2) 
# kernel = (x, y) -> 1./(1+25.*(log.(3+x[1,:]-y[1,:])).^1)
kernel = (x, y) -> 1./(1+10.*log.(3+x[1,:]-y[1,:]))
b1 = SI.CubeBoundingBox{Float64}([-1.0],[2.0])
b2 = SI.CubeBoundingBox{Float64}([-1.0],[2.0])
I1 = SI.getIntervals(b1)
I2 = SI.getIntervals(b2)
kernelR = (rx, ry) -> kernel(SI.RtoX(b1,rx), SI.RtoX(b2,ry))
# The mesh
X = SI.generatePoints(b1,[50])
Y = SI.generatePoints(b2,[50])
# The problem
tols = logspace(-1, -1, 1)
Ktrue = SI.meshKernelFull(kernel, X, Y)
# We compare chebyshev and uniform
# Chebyshev
function XbarCheb(n)
    (orderx, ordery) = SI.getInterpolationOrder(kernelR, I1, I2, n, logLevel=SI.none)
    interpx = SI.TensorInterpolator{Float64}(I1, orderx, SI.chebyshev)
    Xbar = interpx.xk
    Wx   = interpx.w_intk
    return (SI.RtoX(b1, Xbar), Wx)
end
function YbarCheb(n)
    (orderx, ordery) = SI.getInterpolationOrder(kernelR, I1, I2, n, logLevel=SI.none)
    interpy = SI.TensorInterpolator{Float64}(I2, ordery, SI.chebyshev)
    Ybar = interpy.xk
    Wy   = interpy.w_intk
    return (SI.RtoX(b2, Ybar), Wy)
end
# Uniform
function XbarUnif(n)
    Xbar = SI.generateNPoints(b1, n)
    Wx = ones(size(Xbar,2))
    return (Xbar, Wx)
end
function YbarUnif(n)
    Ybar = SI.generateNPoints(b2, n)
    Wy = ones(size(Ybar,2))
    return (Ybar, Wy)
end
# MDV
XbarMDV = n -> (X[:,SI.get_mdv(X, n)], ones(n))
YbarMDV = n -> (Y[:,SI.get_mdv(Y, n)], ones(n))

for (t, tol) in enumerate(tols) 
    stop = (r0, r1, Xhat, Yhat) -> SI.accuracy_stopping_criterion(kernel, X, Y, Xhat, Yhat, Ktrue, tol)
    # Chebyshev
    (Xhat, Yhat, Xbar, Ybar) = SI.adaptive_si(kernel, XbarCheb, YbarCheb, 0.1 * tol, rinit=2, rmax=1000, rinc=x->Int(ceil(x*1.1)), loglevel=SI.debug, stopping_criterion=stop)
    @printf "%e Cheb : r1 %d <- r0 %d\n" tol size(Xhat,2) size(Xbar,2)
    # Uniform
    (Xhat, Yhat, Xbar, Ybar) = SI.adaptive_si(kernel, XbarUnif, YbarUnif, 0.1 * tol, rinit=2, rmax=1000, rinc=x->Int(ceil(x*1.1)), loglevel=SI.debug, stopping_criterion=stop)
    @printf "%e Unif : r1 %d <- r0 %d\n" tol size(Xhat,2) size(Xbar,2)
    # MDV
    (Xhat, Yhat, Xbar, Ybar) = SI.adaptive_si(kernel, XbarMDV,  YbarMDV,  0.1 * tol, rinit=2, rmax=1000, rinc=x->Int(ceil(x*1.1)), loglevel=SI.debug, stopping_criterion=stop)
    @printf "%e MDV : r1 %d <- r0 %d\n" tol size(Xhat,2) size(Xbar,2)
end

lyt = PlotlyJS.Layout(title="Function surface plot")
plt = PlotlyJS.plot(PlotlyJS.contour(x=X[1,:],y=Y[1,:],z=kernel(X,Y)))
