module SI

    export CubeBoundingBox,
           EllipsoidBoundingBox,
           BoundingBox,
           StretchingBox,
           Interval,
           ORDERTYPE,
           ADAPTIVITY

    include("utils.jl")
    include("interval.jl")
    include("generic_adaptive_si.jl")

    abstract type BoundingBox end

    include("ellipsoidfitting.jl")
    include("boundingbox.jl")

    abstract type Interpolator end
    abstract type LowRankInterpolator end

    include("barycentric.jl")
    include("univariaterules.jl")
    include("tensorinterpolator.jl")

    include("interpolationheur.jl")

    include("fastlowrankapprox.jl")
    include("fasterlowrankapprox.jl")

end # module
