function barycentric_weights{T}(x::Array{T, 1})
    @assert length(x) > 0
    n = length(x)
    w = Array{T, 1}(n)
    w[1] = 1.0
    for j = 2:n
        for k = 1:(j-1)
            w[k] = w[k] * (x[k] - x[j]) 
        end
        w[j] = 1.0
        for k = 1:(j-1)
            w[j] = w[j] * (x[j] - x[k])
        end
    end
    w = 1.0 ./ w
    @assert w[1] != 0.0
    w = w ./ w[1] # Normalize in some way ; scale does not matter
    return w
end

function barycentric_interpolate{T}(nodes::Array{T, 1}, f, X::Array{T, 1})
    w = barycentric_weights(nodes)
    @assert size(w) == size(nodes)
    nW = length(w)
    nX = length(X)
    # Compute w_j / (x - x_j)
    WX = zeros(T, (nX, nW))
    for i = 1:nX
        idx = find(x -> x == X[i], nodes)
        @assert length(idx) <= 1
        if length(idx) == 0
            for j = 1:nW
                WX[i,j] = w[j] / (X[i] - nodes[j])
            end
        else
            id = idx[1]
            WX[i,:] = 0.0
            WX[i,id] = 1.0
        end
    end
    # Interpolate
    out = zeros(T, (nX, ))
    fNodes = f(nodes)
    @assert size(fNodes) == size(nodes)
    for i = 1:nX
        out[i] = sum(WX[i,:] .* fNodes) / sum(WX[i,:])
    end
    return out
end
