# Code strongly inspired (but simplified) from 
# https://www.mathworks.com/matlabcentral/fileexchange/24693-ellipsoid-fit
# with the following license

# Copyright (c) 2015, Yury Petrov
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
# * Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in
# the documentation and/or other materials provided with the distribution
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

function ellipsoid3DFitting{U}(X::Array{U, 2})

    @assert size(X)[1] == 3
    n = size(X)[2]

    x = X[1,:]
    y = X[2,:]
    z = X[3,:]

    D = hcat( x.^2+y.^2-2*z.^2 , x.^2+z.^2-2*y.^2 , 2*x.*y , 2*x.*z , 2*y.*z , 2*x , 2*y , 2*z , 1+0*x )
    d = x.^2+y.^2+z.^2

    u = D \ d # least square

    v = Array{U, 1}(10)
    v[1]    = u[1] +   u[2] - 1
    v[2]    = u[1] - 2*u[2] - 1
    v[3]    = u[2] - 2*u[1] - 1
    v[4:10] = u[3:9]

    A = [v[1] v[4] v[5] v[7] ; v[4] v[2] v[6] v[8] ; v[5] v[6] v[3] v[9] ; v[7] v[8] v[9] v[10]]

    center = - A[1:3,1:3] \ v[7:9]

    T = eye(4,4)
    T[4,1:3] = center
    R = T*A*T'
    (evals, evecs) = eig(R[1:3,1:3]/(-R[4,4]))
    radii = sqrt.(1./abs.(evals))
    signs = sign.(evals)

    for i = 1:3
        evecs[:,i] = evecs[:,i] * sign.(evals[i])
    end

    if det(evecs) < 0.0 # So ~ -1.0
        evecs[:,1] = - evecs[:,1]
    end

    (center, radii, evecs)

end
