function getInterpolationOrder(kernel, Ix::Array{Interval{Float64},1}, Iy::Array{Interval{Float64},1}, maxrank ; ruletype::RULETYPE=SI.chebyshev, logLevel=SI.verbose, refx=nothing, refy=nothing)

    Is = [Ix, Iy]
    dims = [0,0]
    for xy = 1:2
        dims[xy] = length(Is[xy])
    end
    if refx == nothing || refy == nothing
        mids = [zeros(dims[1]), zeros(dims[2])]
        for xy = 1:2
            for d = 1:dims[xy]
                mids[xy][d] = Is[xy][d].mid
            end
        end
        refx = mids[1]
        refy = mids[2]
    end
    orders = [ones(Int64, dims[1]), ones(Int64, dims[2])]

    while min(prod(orders[1]), prod(orders[2])) < maxrank # While there is some room for improvement
        
        # Try increasing each space / dimension by 1, use the largest decrease
        errmax = 0.0
        xymax = 0
        dmax = 0
        nRandom = 50

        for xy = 1:2
            for d = 1:dims[xy]
                # Try this one only if does not go above the maximum rank
                neworders = copy(orders[xy])
                neworders[d] += 1
                if prod(neworders) <= maxrank
                    xy_array = Is[xy][d].a+(Is[xy][d].b-Is[xy][d].a)*rand(nRandom)
                    sort!(xy_array)
                    xy_array = reshape(xy_array, (1, nRandom))
                    I = Is[xy][d]
                    interp = TensorInterpolator{Float64}([I], [orders[xy][d]+1], ruletype) # +1 in this space / dimension
                    function kerneld(xy_in) # xy_in is [dim=1 x #pts]
                        @assert size(xy_in)[1] == 1
                        n = size(xy_in)[2]
                        if xy == 1
                            x = vcat(refx[1:d-1] * ones((1,n)) , xy_in , refx[d+1:end] * ones((1,n)))
                            y = refy * ones((1,n))
                        else
                            x = refx * ones((1,n))
                            y = vcat(refy[1:d-1] * ones((1,n)) , xy_in , refy[d+1:end] * ones((1,n)))
                        end
                        return kernel(x,y)
                    end
                    # Compute interpolation
                    fapp = interpolate(interp, xy_array, kerneld)
                    # Compute true value
                    ftrue = kerneld(xy_array)
                    # Compute error
                    err = maximum(abs.(fapp - ftrue))/maximum(abs.(ftrue))
                    if err > errmax
                        errmax = err
                        xymax = xy
                        dmax = d
                    end
                    if logLevel >= SI.debug
                        if xy == 1
                            @printf "x[%d] trying order %d nptsx %d error %e\n" d orders[xy][d]+1 size(interp.xk)[2] err
                        else
                            @printf "y[%d] trying order %d nptsy %d error %e\n" d orders[xy][d]+1 size(interp.xk)[2] err
                        end
                    end
                else
                    if logLevel >= SI.debug
                        @printf "xy[%d][%d] going over maximum rank\n" xy d
                    end
                end
            end
        end

        # Use the worst decrease (that's where we have to work) to increase dimension
        if errmax != 0.0
            orders[xymax][dmax] += 1
        else
            if logLevel >= SI.info
                @printf "Target Maximum rank reached\n"
            end
            break
        end
    end

    return (orders[1], orders[2])

end

