include("../../benchmarks/aca.jl")
include("../../src/SI.jl")

using SI

z = Array(linspace(0.0,1.0,10))
X = SI.tensor_grid([z,z]) # [0, 1] x [0, 1]
Y = SI.tensor_grid([z,z]) # [2, 3] x [2, 3]
Y[1,:] += 2
Y[2,:] += 2
function dist(x, y)
    X_Y = broadcast(-, x, y)
    return sqrt(sum(X_Y.^2, 1))[:]
end
f = (x, y) -> 1.0./dist(x, y)
K = SI.meshKernelFull(f, X, Y)
(U, V) = pp_aca(f, X, Y, 1e-6)
err = norm(U*V' - K)/norm(K)
@printf "Error %e\n" err
