include("../../src/SI.jl") 
using PyPlot
close("all")

# Try Ellipsoid
A = randn((3,100))
for i = 1:100
    A[:,i] /= norm(A[:,i])
end
# PyPlot.figure(1)
# PyPlot.plot3D(A[1,:],A[2,:],A[3,:],"o")
# bb = SI.EllipsoidBoundingBox{Float64}(A, compress=true)
# SI.plotBoundingBox(bb, 1)
# PyPlot.axis("equal")
# 
# # Try torus
# tbb = SI.TorusBoundingBox{Float64}(10.0, 1.0, [-pi+1e-2,pi-1e-2], [-pi/2, pi/2])
# X = SI.generatePoints(tbb,30,30)
# PyPlot.figure()
# plot3D(X[1,:],X[2,:],X[3,:],".")
# xlabel("x")
# ylabel("y")
# zlabel("z")
# axis("equal")
# R = SI.XtoR(tbb,X)
# X2 = SI.RtoX(tbb,R)
# norm(X - X2)/norm(X)

# Try sphere
PyPlot.figure()
sbb = SI.SphereBoundingBox{Float64}(A)
P = SI.generatePoints(sbb, 500)
plot3D(P[1,:],P[2,:],P[3,:],".")
n = 100
u = linspace(0, 2*pi, n)
v = linspace(0, pi, n)
x = sbb.radius * cos(u)  * sin(v)' + sbb.center[1]
y = sbb.radius * sin(u)  * sin(v)' + sbb.center[2]
z = sbb.radius * ones(n) * cos(v)' + sbb.center[3]
surf(x,y,z,rstride=1, cstride=1)
#PyPlot.axis("off")

# PyPlot.figure()
# sbb = SI.SphereBoundingBox{Float64}(A[1:2,:])
# P = SI.generatePoints(sbb, 30)
# plot(P[1,:],P[2,:],".")

# # Try uniform
# PyPlot.figure()
# A[1,:] *= 5
# cbb = SI.CubeBoundingBox{Float64}(A)
# X = SI.generateNPoints(cbb, 500)
# plot3D(X[1,:],X[2,:],X[3,:],".")
# SI.plotBoundingBox(cbb)

