# 2d plates test
include("../../src/SI.jl")
include("../../benchmarks/geometries.jl")
include("../../benchmarks/aca.jl")
using PyPlot
PyPlot.close("all")
srand(0)

# Decide on geometry using provided geometries
(X, Y, b1, b2) = getGeometry(1,30)

# Plot geometry
PyPlot.figure(1)
if b1.dim_x == 2 && b2.dim_x == 2
    PyPlot.plot(X[1,:],X[2,:],"or",markersize=0.5)
    PyPlot.plot(Y[1,:],Y[2,:],"ob",markersize=0.5)
else
    PyPlot.plot3D(X[1,:],X[2,:],X[3,:],"or",markersize=0.5)
    PyPlot.plot3D(Y[1,:],Y[2,:],Y[3,:],"ob",markersize=0.5)
end
SI.plotBoundingBox(b1, 1)
SI.plotBoundingBox(b2, 1)

# Get low rank approx
tol = 1e-8
# kernel = (x,y) -> 1./SI.distance_2(x,y)
function kernel(x::Array{Float64,1}, y::Array{Float64,2})
    return (x[1]-y[1,:])./(SI.distance_2(x,y).^3)
end
function kernel(x::Array{Float64,2}, y::Array{Float64,1})
    return (x[1,:]-y[1])./(SI.distance_2(x,y).^3)
end
function kernel(x::Array{Float64,2}, y::Array{Float64,2})
    return (x[1,:]-y[1,:])./(SI.distance_2(x,y).^3)
end
function kernel(x::Array{Float64,1}, y::Array{Float64,1})
    return (x[1]-y[1])./(SI.distance_2(x,y).^3)
end
kernelR = (x,y) -> kernel(SI.RtoX(b1,x),SI.RtoX(b2,y))
# Faster
I1 = SI.getIntervals(b1)
I2 = SI.getIntervals(b2)
(U,S,V,Xhatr,Yhatr,Xbarr,Ybarr,Uc,Sc,Vc) = SI.fastMeshKernelLowRankApprox(kernelR, I1, I2, SI.XtoR(b1,X), SI.XtoR(b2,Y), tol, tolInterp=0.1, tolQR=0.1, logLevel=SI.debug)
Xhat = SI.RtoX(b1,Xhatr)
Yhat = SI.RtoX(b2,Yhatr)
# Check error
Atrue = SI.meshKernelFull(kernel, X, Y)
Aapp  = U*(S\V')
Aapp2 = Uc*Sc*Vc'
@printf "SI-Cheb errors: %e (compressed %e)\n" vecnorm(Atrue-Aapp)/vecnorm(Atrue) vecnorm(Atrue-Aapp2)/vecnorm(Atrue)
PyPlot.figure(1)
if b1.dim_x == 2 && b2.dim_x == 2
    PyPlot.plot(Xhat[1,:],Xhat[2,:],"*r")
    PyPlot.plot(Yhat[1,:],Yhat[2,:],"*b")
else
    PyPlot.plot3D(Xhat[1,:],Xhat[2,:],Xhat[3,:],"*r")
    PyPlot.plot3D(Yhat[1,:],Yhat[2,:],Yhat[3,:],"*b")
end
# Run ACA
(U, V, I, J) = pp_aca(kernel, X, Y, tol, loglevel=SI.none)
Aaca = U*V'
@printf "ACA errors: %e\n" vecnorm(Atrue-Aaca)/vecnorm(Atrue)
