using PyPlot
using Iterators
include("../../src/SI.jl")
I1 = SI.Interval{Float64}(-1.,1.)
I2 = SI.Interval{Float64}(-1.,1.)
Is = Array([I1, I2])
FF = [x -> exp.(-(x[1,:].^2+x[2,:].^2)), 
      x-> x[1,:].^2 .* x[2,:].^4,  
      x -> cos.(pi*x[1,:]) + sin.(pi*x[2,:]), 
      x -> 1./sqrt.(1+x[1,:].^2+x[2,:].^2)]
for (fidx, f) = enumerate(FF)
    orders = 1:9
    err = zeros(length(orders))
    for (idx,order) = enumerate(orders)
        interp = SI.TensorInterpolator{Float64}(Is, [order, order], SI.chebyshev)
        # Build a X matrix 2 x M
        xx = Array(linspace(I1.a, I1.b, 20))
        yy = Array(linspace(I2.a, I2.b, 20))
        X = SI.tensor_grid([xx, yy])
        # Interpolate
        fapp = SI.interpolate(interp, X, f)
        ftrue = f(X)
        # Error
        errLoc = maximum(abs.(fapp - ftrue))
        @printf "Order %d Err %e\n" order errLoc
        # Print and save
        err[idx] = errLoc
        # Plot points
        Xk = interp.xk
        PyPlot.figure()
        PyPlot.plot(Xk[1,:],Xk[2,:],"or")
    end
    PyPlot.figure()
    PyPlot.semilogy(orders, err)
end
    
