include("../../src/SI.jl")
using PyPlot
PyPlot.close("all")

fs = [x -> exp.(-x.^2), x -> 1.0./abs.(x), x -> 1./sqrt.(1+x.^2), x -> sin.(x).*cos.(3x), x -> x.^10]
names = ["exp(-x^2)","1/abs(x)","1/sqrt(1+x^2)","sin(x)cos(3x)","x^10"]
as = [-1.0, 1.0, -1.0, -Float64(pi), -5.0]
bs = [1.0, 2.0, 1.0, Float64(pi), 5.0]

for (fid, (f, name, a, b)) in enumerate(zip(fs, names, as, bs))

    x = Array(linspace(a,b,1000))
    fx = f(x)

    errsCH = Array{Float64,1}(0)
    nnodesCH = Array{Float64,1}(0)
    errsL = Array{Float64,1}(0)
    nnodesL = Array{Float64,1}(0)
    
    for n = 1:60
        # CH
        (nn,trash,nodes,trash) = SI.getChebyshevNodes(n, a, b)
        fint = SI.barycentric_interpolate(nodes, f, x)
        err = maximum(abs.(fint - fx))./maximum(abs.(fx)) 
        push!(nnodesCH, nn)
        push!(errsCH, err)
    end
    for n = 1:60
        # LE
        (nn,trash,nodes,trash) = SI.getLegendreNodes(n, a, b)
        fint = SI.barycentric_interpolate(nodes, f, x)
        err = maximum(abs.(fint - fx))./maximum(abs.(fx)) 
        push!(nnodesL, nn)
        push!(errsL, err)
    end
    
    figure()
    semilogy(nnodesCH, errsCH, "-o")
    semilogy(nnodesL, errsL, "-o")
    title(string("Error w.r.t. number of nodes for ", name, " on [", a, ",", b, "]"))
    legend(["Chebyshev","Legendre"])
end
