include("../../src/barycentric.jl")
using Base.Test
srand(1)

# Check for Clenshaw-Curtis
for n = 1:50 
    @printf "CC %d\n" n
    for it = 1:10
        a = -1.0-rand()
        b = 1.0+rand()
        I = shuffle(0:n)
        x = (a+b)/2.0 + (b-a)/2.0*cos.(I*pi/n)
        w = barycentric_weights(x)
        wref = (-1.0).^(I)
        id0 = find(x -> x == 0, I)
        idN = find(x -> x == n, I)
        wref[id0] = wref[id0] * 0.5
        wref[idN] = wref[idN] * 0.5
        wref = wref / wref[1] # normalize in the same way as the function
        @test maximum(abs.(wref - w)./abs.(wref)) < 1e-12
    end
end

# Check Chebyshev points first kind
for n = 1:50 
    @printf "Cheb 1st %d\n" n
    for it = 1:10
        a = -1.0-rand()
        b = 1.0+rand()
        I = shuffle(0:n)
        x = (a+b)/2.0 + (b-a)/2.0*cos.( (2*I+1)*pi/(2*n+2) )
        w = barycentric_weights(x)
        wref = (-1.0).^(I) .* sin.( (2*I+1)*pi/(2*n+2) ) 
        wref = wref / wref[1] # normalize in the same way as the function
        @test maximum(abs.(wref - w)./abs.(wref)) < 1e-12
    end
end

# Uniform
for n = 1:10
    @printf "Uniform %d\n" n
    for it = 1:100
        a = -1.0-rand()
        b = 1.0+rand()
        x = convert(Array{Float64, 1}, linspace(a, b, n+1))
        w = barycentric_weights(x)
        bin = Array{Float64, 1}(n+1)
        for k = 1:n+1
            bin[k] = binomial(n,k-1)
        end
        wref = (-1.0).^(0:n) .* bin
        wref = wref / wref[1] # normalize in the same way as the function
        @test maximum(abs.(wref - w)./abs.(wref)) < 1e-12
    end
end
