include("../../src/ellipsoidfitting.jl")
using Base.Test
using PyPlot
srand(1)


# 1. An axis-aligned ellipsoid
for test = 1:100
    a = 1.0+rand()
    b = 3.0+rand()
    c = 2.0+rand()
    n = rand(20:100)
    x0 = randn()
    y0 = randn()
    z0 = randn()

    theta = 2*pi*rand(n)
    phi   =   pi*rand(n)
    x = x0 + a*cos.(theta).*sin.(phi)
    y = y0 + b*sin.(theta).*sin.(phi)
    z = z0 + c*cos.(phi)

    (centers, radii, evecs) = ellipsoid3DFitting(vcat(x',y',z'))

    @test norm(centers - [x0, y0, z0]) < 1e-14
    @test norm(radii - [b, c, a]) < 1e-14
    norm1 = norm(evecs - [0.0 0.0 1.0;1.0 0.0 0.0;0.0 1.0 0.0]) < 1e-14
    norm2 = norm(evecs - [0.0 0.0 -1.0;-1.0 0.0 0.0;0.0 1.0 0.0]) < 1e-14
    @test norm1 || norm2
end

# 2. A non-axis aligned ellipsoid
for test = 1:100

    # Get a random basis
    X = rand(3,3)
    (Q, R) = qr(X)

    a = 1.0+rand()
    b = 3.0+rand()
    c = 2.0+rand()
    n = rand(20:100)

    theta = 2*pi*rand(n)
    phi   =   pi*rand(n)
    x = a*cos.(theta).*sin.(phi)
    y = b*sin.(theta).*sin.(phi)
    z = c*cos.(phi)

    Xr = Q * vcat(x',y',z')
    
    (centers, radii, evecs) = ellipsoid3DFitting(Xr)
    Qr = hcat(Q[:,2], Q[:,3], Q[:,1])

    (Qref, Rref) = qr(Qr)
    (Qtest, Rtest) = qr(evecs)
    

    @test norm(centers) < 1e-14
    @test norm(radii - [b, c, a]) < 1e-14
    @test norm(Qref - Qtest) < 1e-14
    @test norm(abs.(Rref) - eye(3)) < 1e-14
    @test norm(abs.(Rtest) - eye(3)) < 1e-14

end





