include("../../src/SI.jl")
using Base.Test
using Iterators
srand(1)

for (id, ruletype) = enumerate([SI.chebyshev, SI.legendre, SI.uniform])
    @printf "------ %d ------\n" id
    for testId = 1:100
        coefs = rand(1:3, 10) 
        f = x -> 1 + x[1,:].^3 + x[2,:].^3 + x[3,:].^3 + coefs[2] .* x[1,:] + coefs[3] .* x[2,:] .* x[3,:].^2 + coefs[4] .* (x[1,:] + x[2,:] + x[3,:]) 
        I1 = SI.Interval{Float64}(-1.-rand(),0.7.+0.3*rand())
        I2 = SI.Interval{Float64}(-2.-0.5*rand(),1.+rand())
        I3 = SI.Interval{Float64}(-0.5.-0.7*rand(),0.8.+0.5*rand())
        Is = Array([I1, I2, I3])
        # Build interpolator
        orders = [rand(1:6), rand(1:6), rand(1:6)]
        ti = SI.TensorInterpolator{Float64}(Is, orders, ruletype) 
        # Build points
        xxt = linspace(I1.a, I1.b, 20)
        yyt = linspace(I2.a, I2.b, 20)
        zzt = linspace(I3.a, I3.b, 20)
        Xt = Array{Float64,2}(3, length(xxt)*length(yyt)*length(zzt))
        points = product(xxt,yyt,zzt)
        for (i, (x,y,z)) in enumerate(points)
            Xt[:,i] = Array([x;y;z])
        end
        # Interpolate at points
        Xk = ti.xk
        BXk = SI.evalBasis(ti, Xk)
        @test norm(BXk - eye(size(ti.xk)[2])) < 1e-14
        # Interpolate
        fapp = SI.interpolate(ti, Xt, f)
        ftrue = f(Xt)
        errInterp = maximum(abs.(fapp - ftrue)) ./ maximum(abs.(ftrue))
        @printf "Order %s (npts %d) Error %e\n" string(orders) size(ti.xk)[2] errInterp
        # Interpolate polynomial as it should
        npts = Array{Int64,1}(3)
        for d = 1:3
            npts[d] = length(ti.x[d])
        end
        if minimum(npts) >= 4
            @test errInterp < 1e-12
        else
            @test errInterp > 1e-4
        end
    end
end
